<?php

namespace App\Console\Commands;

use App\Models\Karyawan;
use App\Models\JatahCuti;
use Illuminate\Console\Command;

class ResetCutiTahunan extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cuti:reset';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Reset jatah cuti awal tahun (Januari)';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        if (now()->month !== 1) {
            return;
        }

        $tahun = now()->year;
        $karyawan = Karyawan::where('status', 'aktif')->get();

        foreach ($karyawan as $k) {
            JatahCuti::updateOrCreate(
                [
                    'karyawan_id' => $k->id,
                    'tahun' => $tahun
                ],
                [
                    'jatah' => 6
                ]
            );
        }

        activity_log(
            'jatah_cuti',
            'reset',
            'Reset jatah cuti tahunan'
        );

        $this->info('Jatah cuti berhasil di reset ke 6');
        // JatahCuti::where('tahun', now()->year - 1)->delete();
    }
}
